//------------------------------------------------------------------------------
// Lab. 11: Design a full state observer for the system.
//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

//State space model
A=[0 1 0; 0 0 1; 0.6 0.7 0.2 ];
B=[0 0 1]';
C=[1 0 0];
D=0;

//Stabilizer design
// Desired poles
Pd=[0.2,-0.5+0.5*%i,-0.5-0.5*%i];

// State feedback gain matrix
K=ppol(A,B,Pd)

//Computation of gain for dead beat observer response
obsr_pol=[0 0 0];
L=ppol(A',C',obsr_pol)'

// Augmented system
temp=size(A);
Aa=[A-B*K    B*K; zeros(temp(1),temp(2))     A-L*C ];
temp=size(Aa);
Ba=zeros(temp(1),1);
Ca=eye(6,6);
sys=syslin('d',Aa,Ba,Ca,zeros(6,1))

//Observer error 
t=0:0.2:4.5;
u=zeros(1,length(t));
//y=flts(u,sys);
x=ltitr(Aa,Ba,u,[0.1 0.1 0.1 -0.5 -0.5 -0.5]')

temp=size(Aa);
temp=temp(1,1)/2;

col=[1 2 5]; //specifying plot colors
for i=1:temp
    subplot(2,1,1), plot2d2(t,x(i,:),col(1,i))
    if i==temp then
        title('States of the system','fontsize',2);
        xlabel('$t$','fontsize',2);
        ylabel('$x(kT)$','fontsize',2);
        h1=legend('$x_1(kT)$','$x_2(kT)$','$x_3(kT)$');
        h1.legend_location = "in_lower_right";
        xgrid(35)
    end
    subplot(2,1,2), plot2d2(t,x(i+3,:),col(1,i))
    if i==temp then
        title('Observer error','fontsize',2)
        xlabel('$t$','fontsize',2)
        ylabel('$e(kT)=x(kT)-\hat x(kT)$','fontsize',2)
        h2=legend('$e_1(kT)$','$e_2(kT)$','$e_3(kT)$')
        h2.legend_location = "in_lower_right"
        xgrid(35)
    end
end
